package com.amity.socialcloud.sdk.api.core.user.notification

import com.amity.socialcloud.sdk.model.core.notification.AmityUserNotificationModule
import com.amity.socialcloud.sdk.model.core.notification.AmityUserNotificationSettings
import com.amity.socialcloud.sdk.core.domain.user.notification.GetUserNotificationUseCase
import com.amity.socialcloud.sdk.core.domain.user.notification.UpdateUserNotificationUseCase
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Single

class AmityUserNotification internal constructor() {
    
    /* begin_public_function
	  id: notification.enable
	*/
    fun enable(moduleModifiers: List<AmityUserNotificationModule.MODIFIER>? = null): Completable {
        return UpdateUserNotificationUseCase().execute(true, moduleModifiers)
    }
    /* end_public_function */
    
    /* begin_public_function
	  id: notification.disableAll
	*/
    fun disableAllNotifications(): Completable {
        return UpdateUserNotificationUseCase().execute(false)
    }
    /* end_public_function */
    
    /* begin_public_function
	  id: notification.settings
	*/
    fun getSettings(): Single<AmityUserNotificationSettings> {
        return GetUserNotificationUseCase().execute()
    }
    /* end_public_function */

}