package com.amity.socialcloud.sdk.social.domain.storytarget.get

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.api.social.storytarget.AmityGlobalStoryTargetsQueryOption
import com.amity.socialcloud.sdk.model.social.story.AmityStoryTarget
import com.amity.socialcloud.sdk.social.data.storytarget.StoryTargetRepository
import com.amity.socialcloud.sdk.social.domain.storytarget.composer.StoryTargetComposerUseCase
import io.reactivex.rxjava3.core.Flowable
import java.util.concurrent.Executors

internal class GetGlobalStoryTargetsUseCase {

    fun execute(option: AmityGlobalStoryTargetsQueryOption): Flowable<PagingData<AmityStoryTarget>> {
        return StoryTargetRepository().getGlobalFeed(option)
            .map { pagingData ->
                pagingData.map(Executors.newSingleThreadExecutor()) { storyTarget ->
                    StoryTargetComposerUseCase().execute(storyTarget)
                }
            }
    }

}