package com.amity.socialcloud.sdk.chat.data.marker.subchannel

import com.ekoapp.ekosdk.internal.api.AmityHttpClient
import com.ekoapp.ekosdk.internal.api.dto.SubChannelMarkerQueryDto
import com.ekoapp.ekosdk.internal.api.dto.UserSubChannelMarkerQueryDto
import io.reactivex.rxjava3.core.Single

internal class SubChannelMarkerRemoteDataStore {

    fun querySubChannelMarkers(
        subChannelIds: List<String>? = null
    ): Single<SubChannelMarkerQueryDto> {
        return AmityHttpClient.get(SubChannelMarkerApi::class).flatMap {
            it.querySubChannelMarkers(
                subChannelIds = subChannelIds
            )
        }
    }
    
    fun queryUserSubChannelMarkers(
        channelIds: List<String>? = null
    ): Single<UserSubChannelMarkerQueryDto> {
        return AmityHttpClient.get(SubChannelMarkerApi::class).flatMap {
            it.queryUserSubChannelMarkers(
                channelIds = channelIds
            )
        }
    }

}