package com.amity.socialcloud.sdk.api.core.follow

import com.amity.socialcloud.sdk.api.core.follow.query.AmityUserFollowersQuery
import com.amity.socialcloud.sdk.api.core.follow.query.AmityUserFollowingsQuery
import com.amity.socialcloud.sdk.model.core.follow.AmityFollowStatus
import com.amity.socialcloud.sdk.model.core.follow.AmityUserFollowInfo
import com.ekoapp.ekosdk.internal.usecase.user.GetUserFollowInfoUseCase
import com.ekoapp.ekosdk.internal.usecase.user.UserFollowRequestUseCase
import io.reactivex.rxjava3.core.Flowable
import io.reactivex.rxjava3.core.Single

class AmityUserRelationship(private val userId: String) {
    
    @Deprecated("Use AmityCoreClient.newUserRepository().relationship().follow() instead")
    fun follow(): Single<AmityFollowStatus> {
        return UserFollowRequestUseCase().execute(userId)
    }
    
    @Deprecated("Use AmityCoreClient.newUserRepository().relationship().getFollowings() instead")
    fun getFollowings(): AmityUserFollowingsQuery.Builder {
        return AmityUserFollowingsQuery.Builder(userId)
    }
    
    @Deprecated("Use AmityCoreClient.newUserRepository().relationship().getFollowers() instead")
    fun getFollowers(): AmityUserFollowersQuery.Builder {
        return AmityUserFollowersQuery.Builder(userId)
    }
    
    @Deprecated("Use AmityCoreClient.newUserRepository().relationship().getFollowInfo() instead")
    fun getFollowInfo(): Flowable<AmityUserFollowInfo> {
        return GetUserFollowInfoUseCase().execute(userId)
    }
}