package com.amity.socialcloud.sdk.api.core.events

import com.amity.socialcloud.sdk.core.domain.topic.TopicSubscriptionUseCase
import com.amity.socialcloud.sdk.core.domain.topic.TopicUnsubscriptionUseCase
import com.amity.socialcloud.sdk.model.core.events.AmityTopic
import io.reactivex.rxjava3.core.Completable

class AmityTopicSubscription internal constructor(val topic: AmityTopic) {

    fun subscribeTopic(): Completable {
        return TopicSubscriptionUseCase().execute(topic)
    }

    fun unsubscribeTopic(): Completable {
        return TopicUnsubscriptionUseCase().execute(topic)
    }

}