package com.ekoapp.ekosdk.internal.data.model

import androidx.room.Entity
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannel
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannelFilter
import com.amity.socialcloud.sdk.model.core.tag.AmityTags

internal const val CHANNEL_QUERY_TOKEN_TABLE_NAME = "channel_query_token"

@Entity(
    tableName = CHANNEL_QUERY_TOKEN_TABLE_NAME,
    primaryKeys = ["types", "filter", "includingTags", "excludingTags", "pageNumber"]
)
class EkoChannelQueryToken : EkoQueryToken() {
    lateinit var types: List<AmityChannel.Type>
    lateinit var filter: AmityChannelFilter
    lateinit var includingTags: AmityTags
    lateinit var excludingTags: AmityTags
}