package com.amity.socialcloud.sdk.core.data.follow.paging

import com.amity.socialcloud.sdk.model.core.follow.AmityFollowStatusFilter
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator

class FollowingKeyCreator(
    private val userId: String,
    private val followStatusFilter: AmityFollowStatusFilter
) : DynamicQueryStreamKeyCreator {

    override fun toMap(): Map<String, Any> {
        return mapOf(
            "userId" to userId,
            "followStatusFilter" to followStatusFilter.apiKey,
        )
    }

    override fun getFilterQuery(): String {
        return getConditionStatement()
    }

    private fun getConditionStatement(): String {
        //reference filter
        val userIdFilterStatement = "user_follow.sourceUserId = '$userId'"
        //follow status filter
        val followStatusFilterStatement =
            " and user_follow.status IN (${getFollowStatusesAsArrayString()})"
        val deletedUserFilterStatement =
            " and user_follow.targetUserId IN (SELECT userId from user where isDeleted = 0)"
        //compose all condition
        return userIdFilterStatement +
                followStatusFilterStatement +
                deletedUserFilterStatement
    }

    private fun getFollowStatusesAsArrayString(): String {
        val typesString = StringBuilder()
        followStatusFilter.statuses.forEachIndexed { index, status ->
            if (index == 0) {
                typesString.append("'$status'")
            } else {
                typesString.append(", '$status'")
            }
        }
        return typesString.toString()
    }
}