package com.ekoapp.ekosdk.internal.data.dao

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import co.amity.rxremotemediator.AmityPagingId
import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.amity.socialcloud.sdk.model.social.community.AmityCommunityMembershipStatusFilter
import com.amity.socialcloud.sdk.social.data.community.paging.CommunitySemanticSearchKeyCreator
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.entity.CommunityEntity
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagingDao


@Dao
internal interface AmitySearchCommunitiesPagingDao : DynamicQueryStreamPagingDao<CommunityEntity> {

    @RawQuery(observedEntities = [CommunityEntity::class, AmityPagingId::class])
    override fun queryPagingData(sqlQuery: SimpleSQLiteQuery): PagingSource<Int, CommunityEntity>

    fun getSearchCommunitiesPagingSource(
        query: String,
        filter: AmityCommunityMembershipStatusFilter?,
        tags: AmityTags?,
        categoryIds: List<String>?,
        includeDiscoverablePrivateCommunity: Boolean? = null
    ): PagingSource<Int, CommunityEntity> {
        return queryPagingData(
            generateQueryStreamSQL(
                tableName = "community",
                primaryKeyColumnName = "communityId",
                additionalPrimaryKeys = emptyMap(),
                dynamicQueryStreamKeyCreator = CommunitySemanticSearchKeyCreator(
                    query = query,
                    filter = filter,
                    tags = tags,
                    categoryIds = categoryIds,
                    //includeDiscoverablePrivateCommunity = includeDiscoverablePrivateCommunity
                ),
                nonce = AmityNonce.SEARCH_COMMUNITY_LIST,
                order = AmityPagingDao.Order.ASC
            )
        )
    }

}