package com.amity.socialcloud.sdk.social.data.community.membership.paging

import com.amity.socialcloud.sdk.api.social.member.query.AmityCommunityMembershipSortOption
import com.amity.socialcloud.sdk.model.core.role.AmityRoles
import com.amity.socialcloud.sdk.model.social.member.AmityCommunityMembership
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator
import com.ekoapp.ekosdk.internal.keycreator.toSqlArray

internal class CommunityMemberDynamicQueryKeyCreator(
    private val communityId: String,
    private val roles: AmityRoles,
    private val filters: List<AmityCommunityMembership>?,
    private val sortBy: AmityCommunityMembershipSortOption,
    private val isDeleted: Boolean?
) : DynamicQueryStreamKeyCreator {

    override fun toMap(): Map<String, Any> {
        return mapOf(
            "communityId" to communityId,
            "roles" to roles,
            "memberships" to (filters ?: listOf()),
            "sortBy" to sortBy,
            "isDeleted" to (isDeleted?.toString() ?: "null"),
        )
    }

    override fun getFilterQuery(): String {
        return getConditionStatement(communityId, roles, filters, isDeleted)
    }

    private fun getConditionStatement(
        communityId: String,
        roles: AmityRoles,
        memberships: List<AmityCommunityMembership>?,
        isDeleted: Boolean?
    ): String {
        val communityIdFilterStatement = "community_membership.communityId = '$communityId' "
        val membershipFilter = (memberships.takeIf { !it.isNullOrEmpty() } ?: listOf(AmityCommunityMembership.MEMBER, AmityCommunityMembership.BANNED)).map { it.value }.toSqlArray()
        val membershipFilterStatement =
            " and community_membership.communityMembership IN (${membershipFilter})"

        val roleFilterStatement = if (roles.get().isEmpty()) ""
        else " and community_membership.userId IN (SELECT userId from community_role  where communityId = '${communityId}' and roleName IN (${roles.get().toSqlArray()}))"

        val isDeletedFilter = when {
            isDeleted == null || isDeleted -> ""
            else -> " and community_membership.userId IN (SELECT userId from user where isDeleted = 0)"
        }

        return communityIdFilterStatement +
                membershipFilterStatement +
                roleFilterStatement +
                isDeletedFilter
    }

}