package com.amity.socialcloud.sdk.video.data.stream

import androidx.paging.PagingSource
import com.amity.socialcloud.sdk.entity.video.stream.EkoStreamEntity
import com.ekoapp.ekosdk.internal.data.UserDatabase
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Flowable
import io.reactivex.rxjava3.schedulers.Schedulers

internal class StreamLocalDataStore {

    fun saveStream(streams: List<EkoStreamEntity>): Completable {
        return Completable.fromAction { UserDatabase.get().streamDao().save(streams) }
    }

    fun getStream(streamId: String): EkoStreamEntity? {
        var stream: EkoStreamEntity? = null
        Completable.fromCallable {
            val entity = UserDatabase.get().streamDao().getByIdNow(streamId)
            if (entity != null) {
                stream = entity
            }
        }.subscribeOn(Schedulers.io())
            .blockingAwait()
        return stream
    }

    fun observeStream(streamId: String): Flowable<EkoStreamEntity> {
        return UserDatabase.get().streamDao().getById(streamId)
    }

    fun getStreamsPagingSource(statuses: List<String>): PagingSource<Int, EkoStreamEntity> {
        return UserDatabase.get().streamPagingDao().queryStreamList(statuses)
    }

    fun getLatestStream(statuses: List<String>): Flowable<EkoStreamEntity> {
        return UserDatabase.get().streamDao().getLatestStream(statuses)
    }

    fun notifyChanges(streamId: String) {
        UserDatabase.get().streamDao().updateStream(streamId)
    }

    fun updateStreamIsBanned(streamId: String, isBanned: Boolean) {
        UserDatabase.get().streamDao().updateStreamIsBanned(streamId, isBanned)
    }
}