package com.amity.socialcloud.sdk.social.data.community

import com.amity.socialcloud.sdk.common.QueryPersister
import com.amity.socialcloud.sdk.core.data.file.FileEntityMapper
import com.amity.socialcloud.sdk.core.data.file.FileLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.UserEntityMapper
import com.amity.socialcloud.sdk.core.data.user.UserLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagEntityMapper
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagLocalDataStore
import com.amity.socialcloud.sdk.dto.community.JoinRequestQueryDto
import com.amity.socialcloud.sdk.social.data.feed.FeedEntityMapper
import com.amity.socialcloud.sdk.social.data.feed.FeedLocalDataStore
import io.reactivex.rxjava3.core.Completable

internal class CommunityJoinRequestPersister : QueryPersister<JoinRequestQueryDto>() {
    override fun persist(dto: JoinRequestQueryDto): Completable {
        return CommunityJoinRequestLocalDataStore()
            .saveJoinRequest(
                CommunityJoinRequestEntityMapper().map(dto.joinRequests ?: emptyList())
            ).andThen(
                FileLocalDataStore().saveFiles(
                    FileEntityMapper().map(
                        dto.files ?: emptyList()
                    )
                )
            )
            .andThen(
                UserLocalDataStore().saveUsers(
                    UserEntityMapper().map(
                        dto.users ?: emptyList()
                    )
                )
            )
            .andThen(
                UserFlagLocalDataStore().saveFlags(
                    UserFlagEntityMapper().map(
                        dto.users ?: emptyList()
                    )
                )
            )
            .andThen(
                FeedLocalDataStore().saveFeeds(
                    FeedEntityMapper().map(
                        dto.feeds ?: emptyList()
                    )
                )
            )
    }
}