/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.reaction;

import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import co.amity.rxbridge.FlowableKt;
import com.amity.socialcloud.sdk.common.ModelMapper;
import com.amity.socialcloud.sdk.core.data.reaction.ReactionLocalDataStore;
import com.amity.socialcloud.sdk.core.data.reaction.ReactionModelMapper;
import com.amity.socialcloud.sdk.core.data.reaction.ReactionRemoteDataStore;
import com.amity.socialcloud.sdk.core.data.reaction.ReactionRepository;
import com.amity.socialcloud.sdk.core.data.reaction.paging.ReactionMediator;
import com.amity.socialcloud.sdk.core.data.session.SessionLocalDataStore;
import com.amity.socialcloud.sdk.core.session.eventbus.LiveReactionEventBus;
import com.amity.socialcloud.sdk.model.core.reaction.AmityLiveReactionReferenceType;
import com.amity.socialcloud.sdk.model.core.reaction.AmityReaction;
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionReferenceType;
import com.amity.socialcloud.sdk.model.core.reaction.live.AmityLiveReaction;
import com.ekoapp.ekosdk.EkoObjectRepository;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoReactionDao;
import com.ekoapp.ekosdk.internal.data.model.EkoReactionEntity;
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagerCreator;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u001e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0002J&\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006J&\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006J,\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u001a0\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006J\"\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00142\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u001cJ\u001e\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006\u00a8\u0006\u001e"}, d2={"Lcom/amity/socialcloud/sdk/core/data/reaction/ReactionRepository;", "Lcom/ekoapp/ekosdk/EkoObjectRepository;", "()V", "addLiveReactions", "Lio/reactivex/rxjava3/core/Completable;", "liveStreamId", "", "reactions", "", "Lcom/amity/socialcloud/sdk/model/core/reaction/live/AmityLiveReaction;", "addReaction", "referenceType", "Lcom/amity/socialcloud/sdk/model/core/reaction/AmityReactionReferenceType;", "referenceId", "reactionName", "createMyReaction", "Lcom/ekoapp/ekosdk/internal/data/model/EkoReactionEntity;", "getDefaultPageSize", "", "getLatestReaction", "Lio/reactivex/rxjava3/core/Flowable;", "Lcom/amity/socialcloud/sdk/model/core/reaction/AmityReaction;", "getMyReaction", "Lio/reactivex/rxjava3/core/Maybe;", "getMyReactions", "getReactionPagingData", "Landroidx/paging/PagingData;", "observeLiveReactions", "Lcom/amity/socialcloud/sdk/model/core/reaction/AmityLiveReactionReferenceType;", "removeReaction", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nReactionRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactionRepository.kt\ncom/amity/socialcloud/sdk/core/data/reaction/ReactionRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,161:1\n1549#2:162\n1620#2,3:163\n*S KotlinDebug\n*F\n+ 1 ReactionRepository.kt\ncom/amity/socialcloud/sdk/core/data/reaction/ReactionRepository\n*L\n65#1:162\n65#1:163,3\n*E\n"})
public final class ReactionRepository
extends EkoObjectRepository {
    private final int getDefaultPageSize() {
        return 15;
    }

    @NotNull
    public final Flowable<PagingData<AmityReaction>> getReactionPagingData(@NotNull AmityReactionReferenceType referenceType, @NotNull String referenceId, @Nullable String reactionName) {
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        DynamicQueryStreamPagerCreator pagerCreator2 = new DynamicQueryStreamPagerCreator(new PagingConfig(this.getDefaultPageSize(), 0, false, 0, 0, 0, 58, null), null, new ReactionMediator(referenceType, referenceId, reactionName), (Function0)new Function0<PagingSource<Integer, EkoReactionEntity>>(referenceType, referenceId, reactionName){
            final /* synthetic */ AmityReactionReferenceType $referenceType;
            final /* synthetic */ String $referenceId;
            final /* synthetic */ String $reactionName;
            {
                this.$referenceType = $referenceType;
                this.$referenceId = $referenceId;
                this.$reactionName = $reactionName;
                super(0);
            }

            @NotNull
            public final PagingSource<Integer, EkoReactionEntity> invoke() {
                return new ReactionLocalDataStore().getReactionsPagingSource(this.$referenceType, this.$referenceId, this.$reactionName);
            }
        }, (ModelMapper)new ReactionModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator2.create());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getMyReactions(@NotNull AmityReactionReferenceType referenceType, @NotNull String referenceId) {
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        List list2 = CollectionsKt.emptyList();
        EkoReactionDao reactionDao = UserDatabase.get().reactionDao();
        List<EkoReactionEntity> entities = reactionDao.getAllMyReactionsByReferenceTypeAndReferenceIdNow(referenceType.getValue(), referenceId);
        Intrinsics.checkNotNullExpressionValue(entities, (String)"entities");
        if (!((Collection)entities).isEmpty()) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = entities;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                EkoReactionEntity ekoReactionEntity = (EkoReactionEntity)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getReactionName());
            }
            list2 = (List)destination$iv$iv;
        }
        return list2;
    }

    @NotNull
    public final Flowable<AmityReaction> getLatestReaction(@NotNull AmityReactionReferenceType referenceType, @NotNull String referenceId, @Nullable String reactionName) {
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Flowable flowable = new ReactionLocalDataStore().getLatestReaction(referenceType, referenceId, reactionName).map((Function)getLatestReaction.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"ReactionLocalDataStore()\u2026apper().map(it)\n        }");
        return flowable;
    }

    @NotNull
    public final Completable addReaction(@NotNull AmityReactionReferenceType referenceType, @NotNull String referenceId, @NotNull String reactionName) {
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)reactionName, (String)"reactionName");
        Completable completable = this.getMyReaction(referenceType, referenceId, reactionName).subscribeOn(Schedulers.io()).isEmpty().flatMapCompletable(new Function(this, referenceType, referenceId, reactionName){
            final /* synthetic */ ReactionRepository this$0;
            final /* synthetic */ AmityReactionReferenceType $referenceType;
            final /* synthetic */ String $referenceId;
            final /* synthetic */ String $reactionName;
            {
                this.this$0 = $receiver;
                this.$referenceType = $referenceType;
                this.$referenceId = $referenceId;
                this.$reactionName = $reactionName;
            }

            @NotNull
            public final CompletableSource apply(boolean isEmpty) {
                CompletableSource completableSource;
                if (isEmpty) {
                    EkoReactionEntity reaction = this.this$0.createMyReaction(this.$referenceType, this.$referenceId, this.$reactionName);
                    completableSource = (CompletableSource)new ReactionLocalDataStore().addReaction(reaction).concatWith((CompletableSource)new ReactionRemoteDataStore().addReaction(this.$referenceType, this.$referenceId, this.$reactionName).ignoreElement().onErrorResumeNext(new Function(reaction){
                        final /* synthetic */ EkoReactionEntity $reaction;
                        {
                            this.$reaction = $reaction;
                        }

                        @NotNull
                        public final CompletableSource apply(@NotNull Throwable it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return (CompletableSource)new ReactionLocalDataStore().removeReaction(this.$reaction);
                        }
                    }));
                } else {
                    completableSource = (CompletableSource)Completable.complete();
                }
                return completableSource;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fun addReaction(referenc\u2026    }\n            }\n    }");
        return completable;
    }

    @NotNull
    public final Completable removeReaction(@NotNull AmityReactionReferenceType referenceType, @NotNull String referenceId, @NotNull String reactionName) {
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)reactionName, (String)"reactionName");
        Completable completable = this.getMyReaction(referenceType, referenceId, reactionName).subscribeOn(Schedulers.io()).flatMapCompletable(new Function(referenceType, referenceId, reactionName){
            final /* synthetic */ AmityReactionReferenceType $referenceType;
            final /* synthetic */ String $referenceId;
            final /* synthetic */ String $reactionName;
            {
                this.$referenceType = $referenceType;
                this.$referenceId = $referenceId;
                this.$reactionName = $reactionName;
            }

            @NotNull
            public final CompletableSource apply(@NotNull EkoReactionEntity removingReaction) {
                Intrinsics.checkNotNullParameter((Object)removingReaction, (String)"removingReaction");
                return (CompletableSource)new ReactionLocalDataStore().removeReaction(removingReaction).concatWith((CompletableSource)new ReactionRemoteDataStore().removeReaction(this.$referenceType, this.$referenceId, this.$reactionName).ignoreElement().onErrorResumeNext(new Function(removingReaction){
                    final /* synthetic */ EkoReactionEntity $removingReaction;
                    {
                        this.$removingReaction = $removingReaction;
                    }

                    @NotNull
                    public final CompletableSource apply(@NotNull Throwable it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return (CompletableSource)new ReactionLocalDataStore().addReaction(this.$removingReaction);
                    }
                }));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"referenceType: AmityReac\u2026          )\n            }");
        return completable;
    }

    private final Maybe<EkoReactionEntity> getMyReaction(AmityReactionReferenceType referenceType, String referenceId, String reactionName) {
        return new ReactionLocalDataStore().getReaction(referenceType, referenceId, reactionName, new SessionLocalDataStore().getActiveUserId());
    }

    @NotNull
    public final EkoReactionEntity createMyReaction(@NotNull AmityReactionReferenceType referenceType, @NotNull String referenceId, @NotNull String reactionName) {
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)reactionName, (String)"reactionName");
        return new ReactionLocalDataStore().createReaction(referenceType, referenceId, reactionName, new SessionLocalDataStore().getActiveUserId());
    }

    @NotNull
    public final Flowable<List<AmityLiveReaction>> observeLiveReactions(@NotNull String referenceId, @NotNull AmityLiveReactionReferenceType referenceType) {
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)((Object)referenceType), (String)"referenceType");
        Flowable flowable = LiveReactionEventBus.INSTANCE.observe().map(new Function(referenceType, referenceId){
            final /* synthetic */ AmityLiveReactionReferenceType $referenceType;
            final /* synthetic */ String $referenceId;
            {
                this.$referenceType = $referenceType;
                this.$referenceId = $referenceId;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<AmityLiveReaction> apply(@NotNull List<AmityLiveReaction> reactions) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Intrinsics.checkNotNullParameter(reactions, (String)"reactions");
                Iterable iterable = reactions;
                AmityLiveReactionReferenceType amityLiveReactionReferenceType = this.$referenceType;
                String string = this.$referenceId;
                boolean $i$f$filter = false;
                void var6_6 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    AmityLiveReaction it = (AmityLiveReaction)element$iv$iv;
                    boolean bl = false;
                    String string2 = it.getReferenceType();
                    AmityLiveReactionReferenceType.Companion companion = AmityLiveReactionReferenceType.Companion;
                    String p0 = string2;
                    boolean bl2 = false;
                    if (!(companion.enumOf(p0) == amityLiveReactionReferenceType && Intrinsics.areEqual((Object)it.getReferenceId(), (Object)string))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"referenceId: String,\n   \u2026ferenceId }\n            }");
        return flowable;
    }

    @NotNull
    public final Completable addLiveReactions(@NotNull String liveStreamId, @NotNull List<AmityLiveReaction> reactions) {
        Intrinsics.checkNotNullParameter((Object)liveStreamId, (String)"liveStreamId");
        Intrinsics.checkNotNullParameter(reactions, (String)"reactions");
        Completable completable = new ReactionRemoteDataStore().addLiveReactions(liveStreamId, reactions).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"ReactionRemoteDataStore(\u2026         .ignoreElement()");
        return completable;
    }
}

