package com.amity.socialcloud.sdk.social.data.community

import com.amity.socialcloud.sdk.common.QueryPersister
import com.amity.socialcloud.sdk.core.data.file.FileEntityMapper
import com.amity.socialcloud.sdk.core.data.file.FileLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.UserEntityMapper
import com.amity.socialcloud.sdk.core.data.user.UserLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagEntityMapper
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagLocalDataStore
import com.amity.socialcloud.sdk.social.data.category.CategoryEntityMapper
import com.amity.socialcloud.sdk.social.data.category.CategoryLocalDataStore
import com.amity.socialcloud.sdk.social.data.community.membership.CommunityMembershipEntityMapper
import com.amity.socialcloud.sdk.social.data.community.membership.CommunityMembershipLocalDataStore
import com.amity.socialcloud.sdk.social.data.feed.FeedEntityMapper
import com.amity.socialcloud.sdk.social.data.feed.FeedLocalDataStore
import com.ekoapp.ekosdk.internal.api.dto.CommunityListDto
import io.reactivex.rxjava3.core.Completable

internal class CommunityQueryPersister : QueryPersister<CommunityListDto>() {

    override fun persist(dto: CommunityListDto): Completable {
        return FileLocalDataStore().saveFiles(FileEntityMapper().map(dto.files ?: emptyList()))
            .andThen(CategoryLocalDataStore().saveCategories(CategoryEntityMapper().map(dto.categories ?: emptyList())))
            .andThen(UserLocalDataStore().saveUsers(UserEntityMapper().map(dto.users ?: emptyList())))
            .andThen(UserFlagLocalDataStore().saveFlags(UserFlagEntityMapper().map(dto.users ?: emptyList())))
            .andThen(CommunityMembershipLocalDataStore().saveMemberships(CommunityMembershipEntityMapper().map(dto.communityUsers ?: emptyList())))
            .andThen(CommunityMembershipLocalDataStore().saveCommunities(CommunityEntityMapper().map(dto.communities ?: emptyList())))
            .andThen(CommunityLocalDataStore().saveCommunities(CommunityEntityMapper().map(dto.communities ?: emptyList())))
            .andThen(FeedLocalDataStore().saveFeeds(FeedEntityMapper().map(dto.feeds ?: emptyList())))
    }
}