package com.amity.socialcloud.sdk.chat.data.message

import com.amity.socialcloud.sdk.chat.data.marker.message.MessageMarkerEntityMapper
import com.amity.socialcloud.sdk.chat.data.marker.message.MessageMarkerLocalDataStore
import com.amity.socialcloud.sdk.chat.data.marker.subchannel.SubChannelMarkerEntityMapper
import com.amity.socialcloud.sdk.chat.data.marker.subchannel.SubChannelMarkerLocalDataStore
import com.amity.socialcloud.sdk.chat.data.subchannel.SubChannelRepository
import com.amity.socialcloud.sdk.common.QueryPersister
import com.ekoapp.ekosdk.internal.api.dto.MarkedMessageDto
import io.reactivex.rxjava3.core.Completable

internal class MarkedMessageEventPersister : QueryPersister<MarkedMessageDto>() {

    override fun persist(dto: MarkedMessageDto): Completable {
        return  MessageMarkerLocalDataStore().saveAndUpdatePreviousMessageMarkers(MessageMarkerEntityMapper().map(dto.messageMarkers))
            .andThen(SubChannelMarkerLocalDataStore().saveSubChannelMarkers(SubChannelMarkerEntityMapper().map(dto.subChannelMarkers)))
            .andThen(Completable.fromCallable {
                dto.messageMarkers.map { messageMarkerDto ->
                    MessageRepository().updateMarkerHash(messageMarkerDto.messageId,messageMarkerDto.hashCode())
                }
            })
            .andThen(Completable.fromCallable {
                dto.subChannelMarkers.map { subChannelMarkerDto ->
                    SubChannelRepository().updateMarkerHash(subChannelMarkerDto.subChannelId,subChannelMarkerDto.hashCode())
                }
            })
    }

}