package org.amity.diagnostics

import android.util.Log
import timber.log.Timber

internal class TimberLogger(override val name: String) : Logger {
	
	private fun timber(): Timber.Tree {
		return Timber.tag(name)
	}
	
	private fun isLoggable(level: Int): Boolean {
		return Log.isLoggable(name, level)
	}
	
	override val isTraceEnabled: Boolean
		get() = isLoggable(Log.VERBOSE)
	
	override fun trace(msg: String?) {
		timber().v(msg)
	}
	
	override fun trace(msg: String?, t: Throwable?) {
		timber().v(t, TIMBER_FORMAT, msg)
	}
	
	override val isDebugEnabled: Boolean
		get() = isLoggable(Log.DEBUG)
	
	override fun debug(msg: String?) {
		timber().d(msg)
	}
	
	override fun debug(msg: String?, t: Throwable?) {
		timber().d(t, TIMBER_FORMAT, msg)
	}
	
	override val isInfoEnabled: Boolean
		get() = isLoggable(Log.INFO)
	
	override fun info(msg: String?) {
		timber().i(msg)
	}
	
	override fun info(msg: String?, t: Throwable?) {
		timber().i(t, TIMBER_FORMAT, msg)
	}
	
	override val isWarnEnabled: Boolean
		get() = isLoggable(Log.WARN)
	
	override fun warn(msg: String?) {
		timber().w(msg)
	}
	
	override fun warn(msg: String?, t: Throwable?) {
		timber().w(t, TIMBER_FORMAT, msg)
	}
	
	override val isErrorEnabled: Boolean
		get() = isLoggable(Log.ERROR)
	
	override fun error(msg: String?) {
		timber().e(msg)
	}
	
	override fun error(msg: String?, t: Throwable?) {
		timber().e(t, TIMBER_FORMAT, msg)
	}
	
	companion object {
		private const val TIMBER_FORMAT = "%s"
	}
}