package com.ekoapp.ekosdk.internal.util

import com.amity.socialcloud.sdk.api.core.AmityCoreClient;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.core.error.AmityException;

import io.reactivex.functions.Consumer;
import io.reactivex.rxjava3.schedulers.Schedulers;
import retrofit2.HttpException;

object RxEko {
	private val TAG = RxEko::class.java.name
	@JvmField
    val CATCH_UNAUTHORIZED_ERROR_CONSUMER: Consumer<in Throwable> = Consumer { t: Throwable ->
		if (t is AmityException && AmityError.from(t).`is`(AmityError.UNAUTHORIZED_ERROR)
				|| t is HttpException && t.code() == 401) {
			AmityCoreClient.logout()
					.subscribeOn(Schedulers.io())
					.subscribe()
		}
	}
	val LOG_ERROR_CONSUMER: Consumer<in Throwable> = Consumer { t: Throwable ->
		AmityLog.tag(TAG)
				.e(t, "LOG_ERROR_CONSUMER: message: ${t.message}")
	}
	val LOG_CONSUMER = Consumer { o: Any? ->
		AmityLog.tag(TAG).e("LOG_CONSUMER: message: $o")
	}
}