package com.amity.socialcloud.sdk.social.data.community.paging

import androidx.paging.PagingSource
import androidx.room.Dao
import androidx.room.RawQuery
import androidx.sqlite.db.SimpleSQLiteQuery
import co.amity.rxremotemediator.AmityPagingDao
import co.amity.rxremotemediator.AmityPagingId
import com.amity.socialcloud.sdk.api.social.community.query.AmityCommunitySortOption
import com.amity.socialcloud.sdk.entity.comunity.JoinRequestEntity
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.paging.QueryStreamPagingDao

@Dao
internal interface CommunityJoinRequestPagingDao : QueryStreamPagingDao<JoinRequestEntity> {

    @RawQuery(observedEntities = [JoinRequestEntity::class, AmityPagingId::class])
    override fun queryPagingData(sqlQuery: SimpleSQLiteQuery): PagingSource<Int, JoinRequestEntity>

    fun queryCommunityJoinRequests(
        communityId: String,
        status: String,
        sortBy: AmityCommunitySortOption? = null,
        targetType: String,
        type: String,
    ): PagingSource<Int, JoinRequestEntity> {
        return queryPagingData(
            generateQueryStreamSQL(
                tableName = "joinRequest",
                primaryKeyColumnName = "joinRequestId",
                queryStreamKeyCreator = CommunityJoinRequestKeyCreator(
                    communityId,
                    status,
                    sortBy,
                    targetType,
                    type
                ),
                nonce = AmityNonce.JOIN_REQUEST_LIST,
                order = AmityPagingDao.Order.ASC
            )
        )
    }
}