package com.amity.socialcloud.sdk.core.data.notificationtray.notificationtrayseen

import com.amity.socialcloud.sdk.common.EntityMapper
import com.amity.socialcloud.sdk.dto.core.notificationtray.NotificationTraySeenDto
import com.amity.socialcloud.sdk.entity.core.notificationtray.NotificationTraySeenEntity

internal class NotificationTraySeenEntityMapper:
    EntityMapper<NotificationTraySeenDto, NotificationTraySeenEntity>() {

    override fun map(dto: List<NotificationTraySeenDto>): List<NotificationTraySeenEntity> {
        return dto.map { dto -> map(dto) }
    }

    private fun map(dto: NotificationTraySeenDto): NotificationTraySeenEntity {
        return NotificationTraySeenEntity().apply {
            lastTrayOccurredAt = dto.lastTrayOccurredAt
            lastTraySeenAt = dto.lastTraySeenAt
        }

    }
}