package com.amity.socialcloud.sdk.api.social.community.notification

import com.amity.socialcloud.sdk.model.social.notification.AmityCommunityNotificationEvent
import com.amity.socialcloud.sdk.model.social.notification.AmityCommunityNotificationSettings
import com.amity.socialcloud.sdk.social.domain.community.notification.GetCommunityNotificationUseCase
import com.amity.socialcloud.sdk.social.domain.community.notification.UpdateCommunityNotificationUseCase
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Single

class AmityCommunityNotification internal constructor(private val communityId: String) {

    fun enable(eventModifiers: List<AmityCommunityNotificationEvent.MODIFIER>? = null): Completable {
        return UpdateCommunityNotificationUseCase().execute(communityId, true, eventModifiers)
    }

    fun disable(): Completable {
        return UpdateCommunityNotificationUseCase().execute(communityId, false)
    }

    fun getSettings(): Single<AmityCommunityNotificationSettings> {
        return GetCommunityNotificationUseCase().execute(communityId)
    }

}