package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Dao
import androidx.room.Query
import com.ekoapp.ekosdk.internal.entity.TombstoneEntity
import org.joda.time.Duration

@Dao
abstract class TombstoneDao : EkoObjectDao<TombstoneEntity>() {

    @Query("select * from tombstone where objectId = :objectId and modelType = :tombstoneModelType LIMIT 1")
    abstract fun getTombstone(objectId: String, tombstoneModelType: String): TombstoneEntity?

    @Query("DELETE from tombstone")
    abstract override fun deleteAll()

    override fun getExpiration(): Duration = Duration.standardMinutes(3)
}