package com.ekoapp.ekosdk.internal.data.converter

import android.net.Uri
import com.amity.socialcloud.sdk.log.AmityLog
import com.google.gson.Gson
import com.google.gson.GsonBuilder
import com.google.gson.JsonObject
import org.joda.time.DateTime

object EkoGson {
	private val GSON = GsonBuilder()
			.registerTypeAdapter(DateTime::class.java,
				com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter()
			)
			.registerTypeAdapter(Uri::class.java, UriTypeConverter())
			.create()
	
	@JvmStatic
    fun get(): Gson {
		return GSON
	}
	
	// TODO find a better pattern full object, partial update, local field
	fun <T> merge(source: T, patch: T, classOfT: Class<T>?): T {
		return try {
			val sourceJson = toJsonObject(source)
			val patchJson = toJsonObject(patch)
			AmityLog.d("merge: %s sourceJson: %s", sourceJson.javaClass.name, sourceJson)
			AmityLog.d("merge: %s patchJson: %s", patchJson.javaClass.name, patchJson)
			for ((key, value) in patchJson.entrySet()) {
				sourceJson.add(key, value)
			}
			AmityLog.d("merge: %s resultJson: %s", sourceJson.javaClass.name, sourceJson)
			GSON.fromJson(sourceJson, classOfT)
		} catch (e: Exception) {
			AmityLog.e(e)
			source
		}
	}
	
	private fun <T> toJsonObject(obj: T): JsonObject {
		val element = GSON.toJsonTree(obj)
		val jsonObject: JsonObject = if (element is JsonObject) {
			element
		} else {
			JsonObject()
		}
		return jsonObject
	}
}