package com.ekoapp.ekosdk.internal.api.mapper;

import com.google.common.collect.Lists;

import java.util.List;

// FIXME consider find library/framework for generative com.amity.socialcloud.sdk.socket.model transformation (dto, db, pojo, ...)
public interface EkoObjectMapper<DtoType, EntityType> {

    EntityType map(DtoType dto);

    default EntityType update(EntityType objectOnDisk, EntityType objectToSave) {
        return objectToSave;
    }

    default List<EntityType> map(List<DtoType> list) {
        return Lists.transform(list, this::map);
    }

}
