package com.ekoapp.ekosdk.internal

import androidx.room.Entity
import com.ekoapp.ekosdk.EkoObject
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import org.amity.types.ObjectId

@Entity(tableName = "channel_unread_info", primaryKeys = ["channelId"])
open class ChannelUnreadInfoEntity : EkoObject() {
    
    var channelId: String = ObjectId.get().toHexString()
    var unreadCount : Int = 0
    var isMentioned: Boolean = false

    override fun getId(): String {
        return channelId
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        return (other is ChannelUnreadInfoEntity
            && Objects.equal(channelId, other.channelId)
            && Objects.equal(unreadCount, other.unreadCount)
            && Objects.equal(isMentioned, other.isMentioned)
            && Objects.equal(createdAt, other.createdAt)
            && Objects.equal(updatedAt, other.updatedAt)
            )
    }

    override fun hashCode(): Int {
        return Objects.hashCode(
            channelId,
            unreadCount,
            isMentioned,
            createdAt,
            updatedAt
        )
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper?): String {
        toStringHelper?.apply {
            add("channelId", channelId)
            add("unreadCount", unreadCount)
            add("isMentioned", isMentioned)
            add("createdAt", createdAt)
            add("updatedAt", updatedAt)
        }
        return super.internalToString(toStringHelper)
    }

}