package com.amity.socialcloud.sdk.social.data.community

import androidx.paging.PagingSource
import com.amity.socialcloud.sdk.api.social.community.query.AmityCommunitySortOption
import com.amity.socialcloud.sdk.entity.comunity.JoinRequestEntity
import com.amity.socialcloud.sdk.model.core.error.AmityError
import com.amity.socialcloud.sdk.model.core.error.AmityException
import com.amity.socialcloud.sdk.model.social.community.AmityJoinRequestStatus
import com.ekoapp.ekosdk.internal.data.UserDatabase
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Flowable

class CommunityJoinRequestLocalDataStore {

    fun observe(invitationId: String): Flowable<JoinRequestEntity> {
        return UserDatabase.get().communityJoinRequestDao()
            .observeJoinRequest(invitationId)
            .map {
                if (it == null) {
                    throw AmityException.create(
                        message = "item not found",
                        cause = null,
                        error = AmityError.ITEM_NOT_FOUND
                    )
                } else {
                    return@map it
                }
            }
    }

    fun saveJoinRequest(items: List<JoinRequestEntity>): Completable {
        return Completable.fromAction { UserDatabase.get().communityJoinRequestDao().save(items) }
    }

    fun updateJoinRequest(
        targetId: String,
        userId: String,
        status: AmityJoinRequestStatus,
    ): Completable {
        return Completable.fromAction {
            UserDatabase.get().communityJoinRequestDao()
                .updateJoinRequestByTargetIdAndUserId(
                    targetId = targetId,
                    userId = userId,
                    status = status.status
                )
        }
    }

    fun deleteJoinRequest(targetId: String, userId: String): Completable {
        return Completable.fromAction {
            UserDatabase.get().communityJoinRequestDao()
                .deleteJoinRequestByCommunityIdAndUserId(targetId, userId)
        }
    }

    fun getCommunityJoinRequestsPagingSource(
        communityId: String,
        status: String,
        sortBy: AmityCommunitySortOption? = null,
        targetType: String,
        type: String,
    ): PagingSource<Int, JoinRequestEntity> {
        return UserDatabase.get().communityJoinRequestPagingDao()
            .queryCommunityJoinRequests(communityId, status, sortBy, targetType, type)
    }

    fun getJoinRequestList(joinRequestIds: List<String>): Flowable<List<JoinRequestEntity>> {
        return UserDatabase.get().communityJoinRequestDao().observeByJoinRequestIds(joinRequestIds)
    }


//    fun getMyJoinRequest(communityId: String): Single<JoinRequestEntity> {
//        return UserDatabase.get().communityJoinRequestDao().getByIdNow(communityId)
//            .map {
//                if (it == null) {
//                    throw AmityException.create(
//                        message = "item not found",
//                        cause = null,
//                        error = AmityError.ITEM_NOT_FOUND
//                    )
//                } else {
//                    return@map it
//                }
//            }
//    }
}