package com.amity.socialcloud.sdk.chat.data.marker.subchannel

import com.amity.socialcloud.sdk.common.EntityMapper
import com.ekoapp.ekosdk.internal.SubChannelUnreadInfoEntity
import com.ekoapp.ekosdk.internal.api.dto.SubChannelMarkerDto
import com.ekoapp.ekosdk.internal.api.dto.UserSubChannelMarkerDto
import org.amity.types.ObjectId

internal class SubChannelUnreadInfoEntityMapper : EntityMapper<Pair<SubChannelMarkerDto,UserSubChannelMarkerDto>, SubChannelUnreadInfoEntity>() {

    override fun map(list: List<Pair<SubChannelMarkerDto,UserSubChannelMarkerDto>>): List<SubChannelUnreadInfoEntity> {
        return list.map { map(it) }
    }

    fun map(dto: Pair<SubChannelMarkerDto,UserSubChannelMarkerDto>) : SubChannelUnreadInfoEntity {
        return SubChannelUnreadInfoEntity().apply {
            subChannelId = dto.first.subChannelId
            channelId = dto.first.channelId
            unreadCount = dto.second.unreadCount
            isMentioned = dto.second.hasMentioned
            readToSegment = dto.second.readToSegment
            lastSegment = dto.first.lastSegment
            lastMentionSegment = dto.second.lastMentionSegment
            isDeleted = dto.first.isDeleted
            createdAt = dto.second.createdAt
            updatedAt = maxOf(dto.first.updatedAt, dto.second.updatedAt)
        }
    }

}