package com.amity.socialcloud.sdk.chat.data.message.flag

import com.amity.socialcloud.sdk.chat.data.message.MessageApi
import com.ekoapp.ekosdk.internal.api.AmityHttpClient
import com.ekoapp.ekosdk.internal.api.dto.MessageQueryDto
import com.ekoapp.ekosdk.internal.api.socket.request.FlagContentRequest
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

class MessageFlagRemoteDataStore {

    fun flagMessage(messageId: String, request: FlagContentRequest): Single<MessageQueryDto> {
        return AmityHttpClient.get(MessageApi::class).flatMap {
            it.flagMessage(messageId, request)
        }
    }

    fun unflagMessage(messageId: String): Single<MessageQueryDto> {
        return AmityHttpClient.get(MessageApi::class).flatMap {
            it.unflagMessage(messageId)
        }
    }

    fun isFlaggedByMe(messageId: String): Single<JsonObject> {
        return AmityHttpClient.get(MessageApi::class).flatMap {
            it.isFlaggedByMe(messageId)
        }
    }

}