package com.amity.socialcloud.sdk.dto.core.ad

import com.amity.socialcloud.sdk.entity.core.ad.AdEntity
import com.google.gson.JsonObject
import org.joda.time.DateTime


class AdDto {
    var adId: String? = null
    var advertiserId: String? = null
    var name: String? = null
    var placements: List<String>? = null
    var headline: String? = null
    var description: String? = null
    var body: String? = null
    var image1_1: String? = null
    var image9_16: String? = null
    var callToAction: String? = null
    var callToActionUrl: String? = null
    var target: JsonObject? = null
    var startAt: DateTime? = null
    var endAt: DateTime? = null
    var createdAt: DateTime? = null
    var updatedAt: DateTime? = null
}

fun AdDto.toEntity(): AdEntity {
    return AdEntity(
        adId = adId ?: "",
        advertiserId = advertiserId ?: "",
        name = name ?: "",
        placements = placements ?: emptyList(),
        headline = headline ?: "",
        description = description ?: "",
        body = body ?: "",
        image1_1 = image1_1 ?: "",
        image9_16 = image9_16 ?: "",
        callToAction = callToAction ?: "",
        callToActionUrl = callToActionUrl ?: "",
        target = target ?: JsonObject(),
        startAt = startAt,
        endAt = endAt,
    ).apply {
        createdAt = createdAt
        updatedAt = updatedAt
    }
}