/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api;

import com.amity.socialcloud.sdk.AmityOkHttp;
import com.amity.socialcloud.sdk.core.data.session.SessionApi;
import com.amity.socialcloud.sdk.core.session.SessionError;
import com.amity.socialcloud.sdk.core.session.component.SessionComponent;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import com.amity.socialcloud.sdk.infra.retrofit.conveter.Rx3ErrorHandlingCallAdapterFactory;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.ekoapp.ekosdk.internal.api.EkoEndpoint;
import com.ekoapp.ekosdk.internal.api.EkoNotificationApi;
import com.ekoapp.ekosdk.internal.api.http.AmityErrorInterceptor;
import com.ekoapp.ekosdk.internal.data.converter.EkoGson;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import com.google.gson.Gson;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\bH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\bH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/ekoapp/ekosdk/internal/api/AmityHttpClient;", "Lcom/amity/socialcloud/sdk/core/session/component/SessionComponent;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "sessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;)V", "cancelAllRequests", "", "destroy", "establish", "account", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "handleTokenExpire", "observeEndpointChanges", "onSessionStateChange", "sessionState", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "resetInfra", "Companion", "amity-sdk_release"})
public final class AmityHttpClient
extends SessionComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<String, Object> apiMap = new LinkedHashMap();
    @Nullable
    private static Retrofit retrofit;
    @Nullable
    private static Retrofit authRetrofit;
    @Nullable
    private static OkHttpClient okHttpClient;
    @Nullable
    private static OkHttpClient authOkHttpClient;
    private static SessionStateEventBus companionSessionStateEventBus;
    @NotNull
    private static final Set<String> apiKeyRequiredApis;
    @NotNull
    private static SessionState companionSessionState;

    public AmityHttpClient(@NotNull SessionLifeCycleEventBus sessionLifeCycleEventBus, @NotNull SessionStateEventBus sessionStateEventBus) {
        Intrinsics.checkNotNullParameter((Object)sessionLifeCycleEventBus, (String)"sessionLifeCycleEventBus");
        Intrinsics.checkNotNullParameter((Object)sessionStateEventBus, (String)"sessionStateEventBus");
        super(sessionLifeCycleEventBus, sessionStateEventBus);
        this.observeEndpointChanges();
        companionSessionState = this.getSessionState();
        companionSessionStateEventBus = this.getSessionStateEventBus();
    }

    @Override
    public void onSessionStateChange(@NotNull SessionState sessionState) {
        Intrinsics.checkNotNullParameter((Object)sessionState, (String)"sessionState");
        companionSessionState = sessionState;
        Object[] objectArray = new Object[]{"AmityHttpClient onSessionStateChange: " + companionSessionState};
        AmityLog.INSTANCE.e("SSM3", objectArray);
    }

    @Override
    public void establish(@NotNull EkoAccount account) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        Object[] objectArray = new Object[]{"AmityHttpClient establish"};
        AmityLog.INSTANCE.e("SSM3", objectArray);
    }

    @Override
    public void destroy() {
        Object[] objectArray = new Object[]{"AmityHttpClient destroy"};
        AmityLog.INSTANCE.e("SSM3", objectArray);
        this.cancelAllRequests();
        this.resetInfra();
    }

    @Override
    public void handleTokenExpire() {
        this.cancelAllRequests();
    }

    private final void cancelAllRequests() {
        block0: {
            OkHttpClient okHttpClient = authOkHttpClient;
            if (okHttpClient == null || (okHttpClient = okHttpClient.dispatcher()) == null) break block0;
            okHttpClient.cancelAll();
        }
    }

    private final void observeEndpointChanges() {
        EkoEndpoint.INSTANCE.observeHttpUrl().doOnNext(new Consumer(this){
            final /* synthetic */ AmityHttpClient this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AmityHttpClient.access$resetInfra(this.this$0);
            }
        }).subscribeOn(Schedulers.io()).subscribe();
    }

    private final void resetInfra() {
        retrofit = null;
        authRetrofit = null;
        okHttpClient = null;
        authOkHttpClient = null;
        apiMap.clear();
    }

    public static final /* synthetic */ void access$resetInfra(AmityHttpClient $this) {
        $this.resetInfra();
    }

    static {
        Object[] objectArray = new String[]{SessionApi.class.getName(), EkoNotificationApi.class.getName()};
        apiKeyRequiredApis = SetsKt.setOf((Object[])objectArray);
        companionSessionState = SessionState.NotLoggedIn.INSTANCE;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0013\u001a\u0002H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u00012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\nH\u0002J$\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00140\u001c\"\b\b\u0000\u0010\u0014*\u00020\u00012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0016J\b\u0010\u001d\u001a\u00020\nH\u0002J\b\u0010\u001e\u001a\u00020\fH\u0002J\b\u0010\u001f\u001a\u00020\nH\u0002J\b\u0010 \u001a\u00020\fH\u0002J\b\u0010!\u001a\u00020\"H\u0007J \u0010#\u001a\u00020$\"\b\b\u0000\u0010\u0014*\u00020\u00012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0016H\u0002R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/ekoapp/ekosdk/internal/api/AmityHttpClient$Companion;", "", "()V", "apiKeyRequiredApis", "", "", "kotlin.jvm.PlatformType", "apiMap", "", "authOkHttpClient", "Lokhttp3/OkHttpClient;", "authRetrofit", "Lretrofit2/Retrofit;", "companionSessionState", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "companionSessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "okHttpClient", "retrofit", "createApi", "T", "clazz", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)Ljava/lang/Object;", "createRetrofit", "url", "httpClient", "get", "Lio/reactivex/rxjava3/core/Single;", "getAuthOkHttpClient", "getAuthRetrofit", "getOkHttpClient", "getRetrofit", "notification", "Lcom/ekoapp/ekosdk/internal/api/EkoNotificationApi;", "requiresAuthentication", "", "amity-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="Use get() instead")
        @NotNull
        public final EkoNotificationApi notification() {
            Object object = this.get(Reflection.getOrCreateKotlinClass(EkoNotificationApi.class)).blockingGet();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(EkoNotificationApi::class).blockingGet()");
            return (EkoNotificationApi)object;
        }

        @NotNull
        public final <T> Single<T> get(@NotNull KClass<T> clazz) {
            Single single;
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            if (this.requiresAuthentication(clazz) && !(companionSessionState instanceof SessionState.Established)) {
                Single single2 = Single.error((Throwable)SessionError.INSTANCE.fromState(companionSessionState));
                Intrinsics.checkNotNullExpressionValue((Object)single2, (String)"error(SessionError.fromS\u2026e(companionSessionState))");
                return single2;
            }
            Object existingInstance = apiMap.get(JvmClassMappingKt.getJavaClass(clazz).getName());
            if (existingInstance != null) {
                Single single3 = Single.just(existingInstance);
                Intrinsics.checkNotNullExpressionValue((Object)single3, (String)"{\n                    Si\u2026e as T)\n                }");
                single = single3;
            } else {
                T newInstance = this.createApi(clazz);
                Map map = apiMap;
                String string = JvmClassMappingKt.getJavaClass(clazz).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"clazz.java.name");
                map.put(string, newInstance);
                Single single4 = Single.just(newInstance);
                Intrinsics.checkNotNullExpressionValue((Object)single4, (String)"{\n                    va\u2026stance)\n                }");
                single = single4;
            }
            return single;
        }

        private final <T> T createApi(KClass<T> clazz) {
            Object object;
            if (this.requiresAuthentication(clazz)) {
                Object object2 = this.getAuthRetrofit().create(JvmClassMappingKt.getJavaClass(clazz));
                object = object2;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"{\n                getAut\u2026clazz.java)\n            }");
            } else {
                Object object3 = this.getRetrofit().create(JvmClassMappingKt.getJavaClass(clazz));
                object = object3;
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"{\n                getRet\u2026clazz.java)\n            }");
            }
            return (T)object;
        }

        private final Retrofit getRetrofit() {
            if (retrofit == null) {
                AmityHttpClient.retrofit = this.createRetrofit(EkoEndpoint.INSTANCE.getHttpUrl(), this.getOkHttpClient());
            }
            Retrofit retrofit = retrofit;
            Intrinsics.checkNotNull((Object)retrofit);
            return retrofit;
        }

        private final Retrofit getAuthRetrofit() {
            if (authRetrofit == null) {
                authRetrofit = this.createRetrofit(EkoEndpoint.INSTANCE.getHttpUrl(), this.getAuthOkHttpClient());
            }
            Retrofit retrofit = authRetrofit;
            Intrinsics.checkNotNull((Object)retrofit);
            return retrofit;
        }

        private final OkHttpClient getOkHttpClient() {
            if (okHttpClient == null) {
                AmityHttpClient.okHttpClient = AmityOkHttp.Companion.newBuilder$amity_sdk_release().build();
            }
            OkHttpClient okHttpClient = okHttpClient;
            Intrinsics.checkNotNull((Object)okHttpClient);
            return okHttpClient;
        }

        private final OkHttpClient getAuthOkHttpClient() {
            if (authOkHttpClient == null) {
                OkHttpClient.Builder builder = AmityOkHttp.Companion.newBuilder$amity_sdk_release();
                SessionStateEventBus sessionStateEventBus = companionSessionStateEventBus;
                if (sessionStateEventBus == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"companionSessionStateEventBus");
                    sessionStateEventBus = null;
                }
                authOkHttpClient = builder.addNetworkInterceptor((Interceptor)new AmityErrorInterceptor(sessionStateEventBus)).build();
            }
            OkHttpClient okHttpClient = authOkHttpClient;
            Intrinsics.checkNotNull((Object)okHttpClient);
            return okHttpClient;
        }

        private final Retrofit createRetrofit(String url, OkHttpClient httpClient) {
            Retrofit retrofit = new Retrofit.Builder().baseUrl(url).client(httpClient).addCallAdapterFactory(Rx3ErrorHandlingCallAdapterFactory.Companion.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)EkoGson.get())).build();
            Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"Builder()\n              \u2026\n                .build()");
            return retrofit;
        }

        private final <T> boolean requiresAuthentication(KClass<T> clazz) {
            return !apiKeyRequiredApis.contains(JvmClassMappingKt.getJavaClass(clazz).getName());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

