package com.ekoapp.ekosdk.internal.entity

import androidx.room.Entity
import androidx.room.PrimaryKey
import com.ekoapp.ekosdk.EkoObject
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import org.joda.time.DateTime

@Entity(tableName = "user_presence")
data class UserPresenceEntity(
    @PrimaryKey
    var userId: String = "",
    var lastHeartbeat: DateTime? = null,
) : EkoObject() {

    override fun getId(): String {
        return userId
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        return (other as? UserPresenceEntity)?.let { userPresence ->
            (Objects.equal(userId, userPresence.userId)
                    && Objects.equal(lastHeartbeat, userPresence.lastHeartbeat))
        } ?: kotlin.run {
            false
        }
    }

    override fun hashCode(): Int {
        return Objects.hashCode(
            userId,
            lastHeartbeat
        )
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper?): String {
        toStringHelper?.apply {
            add("userId", userId)
            add("lastHeartbeat", lastHeartbeat)
        }
        return super.internalToString(toStringHelper)
    }

}
