package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.chat.data.subchannel.SubChannelLocalDataStore
import com.amity.socialcloud.sdk.chat.data.subchannel.SubChannelQueryPersister
import com.amity.socialcloud.sdk.log.AmityLog
import com.ekoapp.ekosdk.internal.api.dto.SubChannelListDto
import io.reactivex.rxjava3.schedulers.Schedulers
import kotlin.reflect.KClass

internal abstract class SubChannelEventListener : MqttEventListener<SubChannelListDto>() {

    override val type: KClass<SubChannelListDto>
        get() = SubChannelListDto::class

    override fun processEvent(dto: SubChannelListDto) {
        SubChannelQueryPersister().persist(dto)
            .subscribeOn(Schedulers.io())
            .doOnError { AmityLog.e(it) }
            .subscribe()
    }

    override fun shouldProcessEvent(dto: SubChannelListDto): Boolean {
        var shouldProcessEvent = false
        val subChannelId = dto.subChannels.first().subChannelId
        subChannelId?.let {
            shouldProcessEvent = SubChannelLocalDataStore().hasInLocal(it)
        }
        return shouldProcessEvent
    }
}