package com.amity.socialcloud.sdk.core.domain.invitation

import com.amity.socialcloud.sdk.core.domain.ComposerUseCase
import com.amity.socialcloud.sdk.core.domain.user.UserGetUseCase
import com.amity.socialcloud.sdk.model.core.invitation.AmityInvitation
import com.amity.socialcloud.sdk.social.domain.community.CommunityGetUseCase

internal class InvitationComposerUseCase : ComposerUseCase() {

    fun execute(invitation: AmityInvitation): AmityInvitation {
        addUser(invitation)
        addTarget(invitation)
        return invitation
    }

    private fun addUser(invitation: AmityInvitation) {
        invitation.user = UserGetUseCase().execute(invitation.getUserId())
        invitation.createdBy = UserGetUseCase().execute(invitation.getCreatedById())
    }

    private fun addTarget(invitation: AmityInvitation) {
        if (invitation.getTargetType() == "community") {
            invitation.target = CommunityGetUseCase().execute(invitation.getTargetId())
                    ?.let { AmityInvitation.Target.Community(it) }
        }
    }
}