package com.ekoapp.ekosdk.internal.mapper

import com.amity.socialcloud.sdk.model.video.stream.AmityStream
import com.amity.socialcloud.sdk.entity.video.stream.EkoStreamEntity

internal class EkoStreamMapper {

    fun EkoStreamEntity.mapper(): AmityStream {
        return AmityStream(
            streamId = streamId,
            moderationId = moderationId,
            status = AmityStream.Status.enumOf(status),
            title = title,
            description = description,
            resolution = resolution,
            watcherData = watcherData,
            broadcasterData = broadcasterData,
            recordings = recordings,
            thumbnailId = thumbnailFileId,
            userId = userId ?: "",
            metadata = metadata,
            isDeleted = isDeleted,
            referenceId = referenceId,
            referenceType = referenceType,
            targetId = targetId,
            targetType = targetType,
            createdAt = createdAt,
            updatedAt = updatedAt
        )
    }

    fun map(entity: EkoStreamEntity): AmityStream {
        return entity.mapper()
    }
}