package com.amity.socialcloud.sdk.social.domain.community

import com.amity.socialcloud.sdk.model.social.community.AmityJoinResult
import com.amity.socialcloud.sdk.social.data.community.CommunityRepository
import com.ekoapp.ekosdk.internal.constants.COMMUNITY_ID
import com.ekoapp.ekosdk.internal.util.EkoPreconditions
import io.reactivex.rxjava3.core.Single

internal class CommunityJoinRequestUseCase {
    fun execute(communityId: String): Single<AmityJoinResult> {
        EkoPreconditions.checkValidParameter(communityId, COMMUNITY_ID)
        return CommunityRepository().joinRequest(communityId)
    }
}