package com.amity.socialcloud.sdk.social.domain.comment.getbyids

import com.amity.socialcloud.sdk.model.social.comment.AmityComment
import com.amity.socialcloud.sdk.social.data.comment.CommentRepository
import com.amity.socialcloud.sdk.social.domain.comment.CommentComposerUseCase
import io.reactivex.rxjava3.core.Flowable

internal class CommentGetByIdsUseCase {

    fun execute(commentIds: Set<String>): Flowable<List<AmityComment>> {
        return CommentRepository().getCommentByIds(commentIds.toList())
            .map {
                it.onEach { comment ->
                    CommentComposerUseCase().execute(comment)
                }
            }
    }

}