package com.amity.socialcloud.sdk.infra.mqtt.listener

import com.amity.socialcloud.sdk.chat.data.marker.subchannel.SubChannelMarkerRepository
import com.amity.socialcloud.sdk.chat.data.subchannel.SubChannelLocalDataStore
import com.amity.socialcloud.sdk.chat.domain.marker.channel.ReCalculateChannelUnreadInfoUseCase
import com.amity.socialcloud.sdk.core.MarkerEvent
import com.amity.socialcloud.sdk.core.MessagePreviewEvent
import com.amity.socialcloud.sdk.core.session.eventbus.MarkerEventBus
import com.amity.socialcloud.sdk.core.session.eventbus.MessagePreviewEventBus
import com.ekoapp.ekosdk.internal.api.dto.SubChannelListDto
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Single
import io.reactivex.rxjava3.schedulers.Schedulers
import java.util.concurrent.TimeUnit

internal class SubChannelDeleted : SubChannelEventListener() {

    override fun getEventName(): String {
        return "message-feed.deleted"
    }

    override fun processEvent(dto: SubChannelListDto) {
        dto.subChannels.forEach {
            val subChannelId = it.subChannelId ?: ""
            SubChannelLocalDataStore()
                .hardDelete(subChannelId)
                .onErrorComplete()
                .andThen(
                    Completable.fromAction {
                        dto.subChannels.map { subChannel ->
                            MessagePreviewEvent.SubChannelDeleted(subChannel).let(MessagePreviewEventBus::publish)
                            MarkerEventBus.publish(MarkerEvent.SubChannelDeleted(getEventName(), dto))
                            
                            // Delete unread info of deleted sub channel
                            subChannel.subChannelId?.let(SubChannelMarkerRepository()::deleteUnreadInfoBySubChannelId)
                            subChannel.channelId?.let(ReCalculateChannelUnreadInfoUseCase()::execute)
                        }
                    }
                )
                .subscribeOn(Schedulers.io())
                .subscribe()
    
            Single.just(true)
                    .delay(2, TimeUnit.SECONDS)
                    .doOnSuccess {
                        // Delay to ensure that subchannel is already deleted before start marker sync
                        // as a temporary solution until backend has a solution to handle this case.
                        MarkerEventBus.publish(MarkerEvent.MarkerUpdated(getEventName()))
                    }
                    .subscribeOn(Schedulers.io())
                    .subscribe()
        }
    }
}