package com.amity.socialcloud.sdk.api.chat.message.update

import com.amity.socialcloud.sdk.model.core.mention.AmityMentioneeTarget
import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.google.gson.JsonObject


class AmityCustomTextMessageUpdate internal constructor(
    messageId: String,
    private val data: JsonObject?,
    private val tags: AmityTags?
) : AmityMessageUpdate(messageId) {


    override fun getData(): JsonObject? {
        return data
    }

    override fun getTags(): AmityTags? {
        return tags
    }

    override fun getMetadata(): JsonObject? {
        return null
    }

    override fun getMentionees(): List<AmityMentioneeTarget>? {
        return null
    }

    class Builder internal constructor(private val messageId: String) {

        private var data: JsonObject? = null
        private var tags: AmityTags? = null

        fun data(data: JsonObject): Builder {
            return apply {
                this.data = data
            }
        }

        fun tags(tags: AmityTags): Builder {
            return apply { this.tags = tags }
        }

        fun build(): AmityCustomTextMessageUpdate {
            return AmityCustomTextMessageUpdate(messageId, data, tags)
        }

    }

}