package com.ekoapp.ekosdk.internal.usecase.invitation

import androidx.paging.PagingData
import androidx.paging.map
import com.amity.socialcloud.sdk.core.data.invitation.InvitationRepository
import com.amity.socialcloud.sdk.core.data.reaction.paging.InvitationMediator
import com.amity.socialcloud.sdk.core.domain.invitation.InvitationComposerUseCase
import com.amity.socialcloud.sdk.core.domain.reaction.ReactionComposerUseCase
import com.amity.socialcloud.sdk.model.core.invitation.AmityInvitation
import com.amity.socialcloud.sdk.model.core.invitation.AmityInvitationType
import io.reactivex.rxjava3.core.Flowable
import java.util.concurrent.Executors

internal class InvitationPagingDataUseCase {

    fun execute(type: AmityInvitationType, target: InvitationMediator.Target): Flowable<PagingData<AmityInvitation>> {
        return InvitationRepository().getInvitationPagingData(type, target)
            .map { pagingData ->
                pagingData.map(Executors.newSingleThreadExecutor()) { invitation ->
                    InvitationComposerUseCase().execute(invitation)
                }
            }
    }

}