package com.ekoapp.ekosdk.internal.data.converter

import androidx.room.TypeConverter
import com.ekoapp.ekosdk.internal.data.model.EkoPushConfig
import com.ekoapp.ekosdk.internal.data.model.EkoPushConfig.State.Companion.enumOf


class EkoPushConfigStateConverter {
	@TypeConverter
	fun stringToEkoPushConfigState(apiKey: String): EkoPushConfig.State? {
		return enumOf(apiKey)
	}
	
	@TypeConverter
	fun ekoPushConfigStateToString(state: EkoPushConfig.State): String {
		return state.apiKey
	}
}