package com.amity.socialcloud.sdk.api.chat.member.query



enum class AmityChannelMembership(val apiKey: String) {
    MEMBER("member"),
    MUTED("muted"),
    BANNED("banned");

    companion object {

        fun enumOf(apiKey: String): AmityChannelMembership {
            return values().find {
                it.apiKey == apiKey
            } ?: MEMBER
        }
    }

}