package com.amity.socialcloud.sdk.core.data.notification.community


import com.amity.socialcloud.sdk.model.social.notification.AmityCommunityNotificationEvent
import com.amity.socialcloud.sdk.model.social.notification.AmityCommunityNotificationSettings
import com.ekoapp.ekosdk.internal.api.mapper.EkoCommunityNotificationEventRequestMapper
import com.ekoapp.ekosdk.internal.api.socket.request.NotificationSaveSettingsRequest
import com.ekoapp.ekosdk.internal.mapper.EkoPushNotificationMapper
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Single

class CommunityNotificationRepository {

    fun saveNotificationSettings(
        communityId: String,
        isEnabled: Boolean,
        eventModifiers: List<AmityCommunityNotificationEvent.MODIFIER>?
    ): Completable {
        return CommunityNotificationRemoteDataStore().saveSetting(communityId, isEnabled, eventModifiers)
            .ignoreElement()
    }

    fun getNotificationSettings(communityId: String): Single<AmityCommunityNotificationSettings> {
        return CommunityNotificationRemoteDataStore().getSetting(communityId)
            .map { pushNotificationDto ->
                EkoPushNotificationMapper().mapToCommunityNotificationSettings(pushNotificationDto)
            }
    }

}