package com.amity.socialcloud.sdk.social.domain.community

import com.amity.socialcloud.sdk.core.domain.ComposerUseCase
import com.amity.socialcloud.sdk.core.domain.file.ImageGetUseCase
import com.amity.socialcloud.sdk.core.domain.user.UserGetUseCase
import com.amity.socialcloud.sdk.model.social.community.AmityCommunity
import com.amity.socialcloud.sdk.social.domain.category.get.CategoryGetUseCase

internal class CommunityComposerUseCase : ComposerUseCase() {

    fun execute(community: AmityCommunity): AmityCommunity {
        UserGetUseCase().execute(community.getCreatorId())?.let {
            community.user = it
        }
        ImageGetUseCase().execute(community.getAvatarFileId())?.let {
            community.avatarImage = it
        }
        CategoryGetUseCase().execute(community.getCategoryIds()).let {
            community.categories = it
        }
        return community
    }
}