package com.amity.socialcloud.sdk.model.chat.message

enum class MessageDeliveredMembershipFilter(val apiKey: String) {
	MEMBER("member"),
	BANNED("banned"),
	MUTED("muted"),
	NOT_MEMBER("non-member"),
	DELETED("deleted");
	
	companion object {
		fun enumOf(apiKey: String) : MessageDeliveredMembershipFilter {
			return values().find {
				it.apiKey == apiKey
			} ?: MEMBER
		}
	}
}