/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.entity.social.category.CommunityCategoryEntity;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityCategoryDao;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class EkoCommunityCategoryDao_Impl
extends EkoCommunityCategoryDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<CommunityCategoryEntity> __insertionAdapterOfCommunityCategoryEntity;
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<CommunityCategoryEntity> __deletionAdapterOfCommunityCategoryEntity;
    private final EntityDeletionOrUpdateAdapter<CommunityCategoryEntity> __updateAdapterOfCommunityCategoryEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public EkoCommunityCategoryDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfCommunityCategoryEntity = new EntityInsertionAdapter<CommunityCategoryEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `community_category` (`categoryId`,`name`,`avatarFileId`,`metadata`,`isDeleted`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, CommunityCategoryEntity value) {
                if (value.getCategoryId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCategoryId());
                }
                if (value.getName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getName());
                }
                if (value.getAvatarFileId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getAvatarFileId());
                }
                String _tmp = EkoCommunityCategoryDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                int _tmp_1 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp_1);
                String _tmp_2 = EkoCommunityCategoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_2);
                }
                String _tmp_3 = EkoCommunityCategoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_3);
                }
                String _tmp_4 = EkoCommunityCategoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_4);
                }
            }
        };
        this.__deletionAdapterOfCommunityCategoryEntity = new EntityDeletionOrUpdateAdapter<CommunityCategoryEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `community_category` WHERE `categoryId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, CommunityCategoryEntity value) {
                if (value.getCategoryId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCategoryId());
                }
            }
        };
        this.__updateAdapterOfCommunityCategoryEntity = new EntityDeletionOrUpdateAdapter<CommunityCategoryEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `community_category` SET `categoryId` = ?,`name` = ?,`avatarFileId` = ?,`metadata` = ?,`isDeleted` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `categoryId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, CommunityCategoryEntity value) {
                if (value.getCategoryId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCategoryId());
                }
                if (value.getName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getName());
                }
                if (value.getAvatarFileId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getAvatarFileId());
                }
                String _tmp = EkoCommunityCategoryDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                int _tmp_1 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp_1);
                String _tmp_2 = EkoCommunityCategoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_2);
                }
                String _tmp_3 = EkoCommunityCategoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_3);
                }
                String _tmp_4 = EkoCommunityCategoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_4);
                }
                if (value.getCategoryId() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getCategoryId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from community_category";
                return "DELETE from community_category";
            }
        };
    }

    @Override
    public void insertImpl(CommunityCategoryEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfCommunityCategoryEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends CommunityCategoryEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfCommunityCategoryEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends CommunityCategoryEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfCommunityCategoryEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(CommunityCategoryEntity category) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfCommunityCategoryEntity.handle((Object)category);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(CommunityCategoryEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfCommunityCategoryEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(CommunityCategoryEntity object) {
        this.__db.beginTransaction();
        try {
            EkoCommunityCategoryDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends CommunityCategoryEntity> objects) {
        this.__db.beginTransaction();
        try {
            EkoCommunityCategoryDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(CommunityCategoryEntity object) {
        this.__db.beginTransaction();
        try {
            EkoCommunityCategoryDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    CommunityCategoryEntity getByIdNowImpl(String id) {
        String _sql = "SELECT * from community_category where community_category.categoryId = (?)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from community_category where community_category.categoryId = (?)", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            CommunityCategoryEntity _result;
            int _cursorIndexOfCategoryId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"categoryId");
            int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
            int _cursorIndexOfAvatarFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatarFileId");
            int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                _result = new CommunityCategoryEntity();
                String _tmpCategoryId = _cursor.isNull(_cursorIndexOfCategoryId) ? null : _cursor.getString(_cursorIndexOfCategoryId);
                _result.setCategoryId(_tmpCategoryId);
                String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                _result.setName(_tmpName);
                String _tmpAvatarFileId = _cursor.isNull(_cursorIndexOfAvatarFileId) ? null : _cursor.getString(_cursorIndexOfAvatarFileId);
                _result.setAvatarFileId(_tmpAvatarFileId);
                String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                _result.setMetadata(_tmpMetadata);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_1 != 0;
                _result.setDeleted(_tmpIsDeleted);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            CommunityCategoryEntity communityCategoryEntity = _result;
            return communityCategoryEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    Flowable<CommunityCategoryEntity> observeByIdImpl(String id) {
        String _sql = "SELECT * from community_category where community_category.categoryId = (?)";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from community_category where community_category.categoryId = (?)", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"community_category"}, (Callable)new Callable<CommunityCategoryEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CommunityCategoryEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoCommunityCategoryDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    CommunityCategoryEntity _result;
                    int _cursorIndexOfCategoryId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"categoryId");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfAvatarFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatarFileId");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new CommunityCategoryEntity();
                        String _tmpCategoryId = _cursor.isNull(_cursorIndexOfCategoryId) ? null : _cursor.getString(_cursorIndexOfCategoryId);
                        _result.setCategoryId(_tmpCategoryId);
                        String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                        _result.setName(_tmpName);
                        String _tmpAvatarFileId = _cursor.isNull(_cursorIndexOfAvatarFileId) ? null : _cursor.getString(_cursorIndexOfAvatarFileId);
                        _result.setAvatarFileId(_tmpAvatarFileId);
                        String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = EkoCommunityCategoryDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                        _result.setMetadata(_tmpMetadata);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_1 != 0;
                        _result.setDeleted(_tmpIsDeleted);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoCommunityCategoryDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoCommunityCategoryDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = EkoCommunityCategoryDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    CommunityCategoryEntity communityCategoryEntity = _result;
                    return communityCategoryEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<CommunityCategoryEntity> getByIdsNowImpl(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from community_category where community_category.categoryId IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfCategoryId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"categoryId");
            int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
            int _cursorIndexOfAvatarFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatarFileId");
            int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            ArrayList<CommunityCategoryEntity> _result = new ArrayList<CommunityCategoryEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                CommunityCategoryEntity _item_1 = new CommunityCategoryEntity();
                String _tmpCategoryId = _cursor.isNull(_cursorIndexOfCategoryId) ? null : _cursor.getString(_cursorIndexOfCategoryId);
                _item_1.setCategoryId(_tmpCategoryId);
                String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                _item_1.setName(_tmpName);
                String _tmpAvatarFileId = _cursor.isNull(_cursorIndexOfAvatarFileId) ? null : _cursor.getString(_cursorIndexOfAvatarFileId);
                _item_1.setAvatarFileId(_tmpAvatarFileId);
                String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                _item_1.setMetadata(_tmpMetadata);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_1 != 0;
                _item_1.setDeleted(_tmpIsDeleted);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _item_1.setCreatedAt(_tmpCreatedAt);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                _item_1.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                _item_1.setExpiresAt(_tmpExpiresAt);
                _result.add(_item_1);
            }
            ArrayList<CommunityCategoryEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    Flowable<CommunityCategoryEntity> getLatestCategoryImpl(Boolean isDeleted, int hash, int nonce, DateTime now) {
        Integer _tmp_1;
        Integer _tmp;
        String _sql = "SELECT * from community_category where community_category.isDeleted = (case when ? is null then isDeleted else ? end) and community_category.updatedAt > ? and community_category.categoryId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (?) and amity_paging_id.nonce = (?) ) order by community_category.updatedAt  desc limit 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from community_category where community_category.isDeleted = (case when ? is null then isDeleted else ? end) and community_category.updatedAt > ? and community_category.categoryId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (?) and amity_paging_id.nonce = (?) ) order by community_category.updatedAt  desc limit 1", (int)5);
        int _argIndex = 1;
        Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 2;
        Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 3;
        String _tmp_2 = this.__dateTimeTypeConverter.dateTimeToString(now);
        if (_tmp_2 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp_2);
        }
        _argIndex = 4;
        _statement.bindLong(_argIndex, (long)hash);
        _argIndex = 5;
        _statement.bindLong(_argIndex, (long)nonce);
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"community_category", "amity_paging_id"}, (Callable)new Callable<CommunityCategoryEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CommunityCategoryEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoCommunityCategoryDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    CommunityCategoryEntity _result;
                    int _cursorIndexOfCategoryId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"categoryId");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfAvatarFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatarFileId");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new CommunityCategoryEntity();
                        String _tmpCategoryId = _cursor.isNull(_cursorIndexOfCategoryId) ? null : _cursor.getString(_cursorIndexOfCategoryId);
                        _result.setCategoryId(_tmpCategoryId);
                        String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                        _result.setName(_tmpName);
                        String _tmpAvatarFileId = _cursor.isNull(_cursorIndexOfAvatarFileId) ? null : _cursor.getString(_cursorIndexOfAvatarFileId);
                        _result.setAvatarFileId(_tmpAvatarFileId);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = EkoCommunityCategoryDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_3);
                        _result.setMetadata(_tmpMetadata);
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_4 != 0;
                        _result.setDeleted(_tmpIsDeleted);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoCommunityCategoryDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoCommunityCategoryDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = EkoCommunityCategoryDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    CommunityCategoryEntity communityCategoryEntity = _result;
                    return communityCategoryEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

