package com.amity.socialcloud.sdk.entity.core.ad

import androidx.room.Entity
import androidx.room.PrimaryKey
import com.amity.socialcloud.sdk.model.core.ad.AmityAd
import com.amity.socialcloud.sdk.model.core.ad.AmityAdPlacement
import com.ekoapp.ekosdk.EkoObject
import com.google.common.base.Objects
import com.google.gson.JsonObject
import org.amity.types.ObjectId
import org.joda.time.DateTime


@Entity(tableName = "ad")
open class AdEntity(
    @PrimaryKey
    var adId: String = ObjectId.get().toHexString(),
    var advertiserId: String,
    var name: String,
    var placements: List<String>,
    var headline: String,
    var description: String,
    var body: String,
    var image1_1: String?,
    var image9_16: String?,
    var callToAction: String,
    var callToActionUrl: String,
    var target: JsonObject,
    var startAt: DateTime?,
    var endAt: DateTime?,
) : EkoObject() {

    override fun getId(): String {
        return adId
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        if (other.javaClass != javaClass) return false
        return (Objects.equal(adId, (other as AdEntity).adId)
                && Objects.equal(name, other.name)
                && Objects.equal(advertiserId, other.advertiserId)
                && Objects.equal(placements, other.placements)
                && Objects.equal(headline, other.headline)
                && Objects.equal(description, other.description)
                && Objects.equal(body, other.body)
                && Objects.equal(image1_1, other.image1_1)
                && Objects.equal(image9_16, other.image9_16)
                && Objects.equal(callToAction, other.callToAction)
                && Objects.equal(callToActionUrl, other.callToActionUrl)
                && Objects.equal(target, other.target)
                && Objects.equal(startAt, other.startAt)
                && Objects.equal(endAt, other.endAt)
                && Objects.equal(updatedAt, other.updatedAt))
    }

    override fun hashCode(): Int {
        return Objects.hashCode(
            adId,
            advertiserId,
            placements,
            name,
            headline,
            description,
            body,
            image1_1,
            image9_16,
            callToAction,
            callToActionUrl,
            target,
            startAt,
            endAt,
            updatedAt,
        )
    }

}

internal fun AdEntity.toModel(): AmityAd {
    return AmityAd(
        adId = adId,
        advertiserId = advertiserId,
        name = name,
        placements = placements.filter { AmityAdPlacement.enumOf(it) != null }.map { AmityAdPlacement.enumOf(it)!! },
        headline = headline,
        description = description,
        body = body,
        image1_1FileId = image1_1,
        image9_16FileId = image9_16,
        callToAction = callToAction,
        callToActionUrl = callToActionUrl,
        adTarget = target,
        startAt = startAt,
        endAt = endAt,
        createdAt = createdAt ?: DateTime.now(),
        updatedAt = updatedAt ?: DateTime.now()
    )
}