package com.amity.socialcloud.sdk.api.core.session

import com.amity.socialcloud.sdk.core.domain.session.LoginUseCase
import com.amity.socialcloud.sdk.core.session.eventbus.AppEventBus
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus
import io.reactivex.rxjava3.core.Completable

class AmitySessionEstablisher private constructor(
    private val appEventBus: AppEventBus?,
    private val sessionLifeCycleEventBus: SessionLifeCycleEventBus?,
    private val userId: String,
    private val displayName: String?,
    private val authToken: String?,
    private val isLegacyVersion: Boolean
) {

    fun submit(): Completable {
        return LoginUseCase().execute(
            appEventBus = appEventBus,
            sessionLifeCycleEventBus = sessionLifeCycleEventBus,
            userId = userId,
            displayName = displayName,
            authToken = authToken,
            isLegacyVersion = isLegacyVersion
        )
            .ignoreElement()
    }

    class Builder internal constructor(
        private val appEventBus: AppEventBus?,
        private val sessionLifeCycleEventBus: SessionLifeCycleEventBus?,
        private val userId: String,
        private val isLegacyVersion: Boolean
    ) {

        private var displayName: String? = null
        private var authToken: String? = null

        fun displayName(displayName: String): Builder {
            this.displayName = displayName
            return this
        }

        fun authToken(authToken: String): Builder {
            this.authToken = authToken
            return this
        }

        fun build(): AmitySessionEstablisher {
            return AmitySessionEstablisher(
                appEventBus = appEventBus,
                sessionLifeCycleEventBus = sessionLifeCycleEventBus,
                userId = userId,
                displayName = displayName,
                authToken = authToken,
                isLegacyVersion = isLegacyVersion
            )
        }
    }

}