package com.ekoapp.ekosdk.internal.api.http

import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus
import com.amity.socialcloud.sdk.core.session.model.SessionState
import com.amity.socialcloud.sdk.log.AmityLog
import com.amity.socialcloud.sdk.model.core.error.AmityError
import com.amity.socialcloud.sdk.model.core.error.AmityException
import okhttp3.Headers
import okhttp3.Interceptor
import okhttp3.Response
import okhttp3.internal.http.RealResponseBody
import okio.GzipSource
import okio.buffer
import java.io.IOException


internal class AmityErrorInterceptor(val sessionStateEventBus: SessionStateEventBus) : Interceptor {

    @Throws(IOException::class)
    override fun intercept(chain: Interceptor.Chain): Response {
        val response: Response = try {
            chain.proceed(chain.request().newBuilder()
                //.removeHeader("Accept-Encoding")
                .build())
        } catch (e: Exception) {
            throw e
        }

        if (!response.isSuccessful) {
            val unzippedResponse = unzip(response)
            unzippedResponse?.run {
                val amityError = AmityException.fromResponse(this)
                if (amityError.code == AmityError.UNAUTHORIZED_ERROR.code
                    || amityError.code == AmityError.USER_IS_GLOBAL_BANNED.code
                ) {
                    sessionStateEventBus.publish(SessionState.Terminated(amityError))
                }
                AmityLog.e("SSM3", "<-- HTTP FAILED: ${amityError.code}")
            }
        }
        return response
    }

    @Throws(IOException::class)
    private fun unzip(response: Response): Response? {
        val contentEncoding = response.headers["Content-Encoding"]
        val hasZippedResponse = contentEncoding != null && contentEncoding == "gzip"
        return if (hasZippedResponse) {
            val peekedResponse = response.peekBody(Long.MAX_VALUE)
            if (peekedResponse == null) {
                return response
            }
            val contentLength = peekedResponse.contentLength()
            val responseBody = GzipSource(peekedResponse.source())
            val strippedHeaders: Headers = response.headers.newBuilder().build()
            response.newBuilder().headers(strippedHeaders)
                .body(
                    RealResponseBody(
                        peekedResponse.contentType().toString(),
                        contentLength,
                        responseBody.buffer()
                    )
                )
                .build()
        } else {
            response
        }
    }

}
