package com.ekoapp.ekosdk.internal

import androidx.room.Entity
import com.ekoapp.ekosdk.EkoObject
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import org.amity.types.ObjectId

@Entity(tableName = "message_marker", primaryKeys = ["messageId"])
open class MessageMarkerEntity : EkoObject() {
    
    var messageId: String = ObjectId.get().toHexString()
    var subChannelId: String = ""
    var readCount : Int = 0
    var deliveredCount: Int = 0

    override fun getId(): String {
        return messageId
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        return (other is MessageMarkerEntity
                && Objects.equal(messageId, other.messageId)
                && Objects.equal(subChannelId, other.subChannelId)
                && Objects.equal(readCount, other.readCount)
                && Objects.equal(deliveredCount, other.deliveredCount)
                && Objects.equal(createdAt, other.createdAt)
                && Objects.equal(updatedAt, other.updatedAt)
                )
    }

    override fun hashCode(): Int {
        return Objects.hashCode(
            messageId,
            subChannelId,
            readCount,
            deliveredCount,
            createdAt,
            updatedAt
        )
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper?): String {
        toStringHelper?.apply {
            add("messageId", messageId)
            add("subChannelId", subChannelId)
            add("readCount", readCount)
            add("deliveredCount", deliveredCount)
            add("createdAt", createdAt)
            add("updatedAt", updatedAt)
        }
        return super.internalToString(toStringHelper)
    }

}