package com.amity.socialcloud.sdk.helper.core.mention

import android.os.Parcelable
import com.amity.socialcloud.sdk.model.core.user.AmityUser
import kotlinx.parcelize.Parcelize

/* begin_public_function
  id: core.model.mentionee
*/
sealed class AmityMentionee : Parcelable {

    @Parcelize
    object CHANNEL : AmityMentionee()

    @Parcelize
    class USER constructor(private val userId: String) : AmityMentionee() {
        internal var user: AmityUser? = null

        internal constructor(userId : String, user: AmityUser?) : this(userId) {
            this.user = user
        }

        fun getUserId(): String {
            return userId
        }

        fun getUser(): AmityUser? {
            return user
        }
    }
}
/* end_public_function */