package com.amity.socialcloud.sdk.core.session.component

import com.amity.socialcloud.sdk.core.domain.session.ClearDatabaseUseCase
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus
import com.amity.socialcloud.sdk.core.session.model.SessionState
import com.ekoapp.ekosdk.internal.data.UserDatabase
import com.ekoapp.ekosdk.internal.data.model.EkoAccount
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.schedulers.Schedulers

class DatabaseSessionComponent(
    sessionLifeCycleEventBus: SessionLifeCycleEventBus,
    sessionStateEventBus: SessionStateEventBus
) :
    SessionComponent(
        sessionLifeCycleEventBus, sessionStateEventBus
    ) {
    override fun onSessionStateChange(sessionState: SessionState) {

    }

    override fun establish(account: EkoAccount) {
        Completable.fromAction {
            val channelDao = UserDatabase.get().channelDao()
            channelDao.deleteAllLocallyInactiveChannelsAndUpdateAllActiveChannelsToNotReading()
        }
            .subscribeOn(Schedulers.io())
            .subscribe()

    }

    override fun destroy() {
        ClearDatabaseUseCase().execute().subscribeOn(Schedulers.io()).subscribe()
    }

    override fun handleTokenExpire() {
        ClearDatabaseUseCase().execute().subscribeOn(Schedulers.io()).subscribe()
    }
}