package com.amity.socialcloud.sdk.infra.mqtt.listener



import com.amity.socialcloud.sdk.dto.video.EkoStreamListDto
import com.amity.socialcloud.sdk.video.data.stream.StreamQueryPersister
import io.reactivex.rxjava3.schedulers.Schedulers
import kotlin.reflect.KClass

internal abstract class StreamEventListener: MqttEventListener<EkoStreamListDto>() {

    override val type: KClass<EkoStreamListDto>
        get() = EkoStreamListDto::class

    override fun processEvent(dto: EkoStreamListDto) {
        StreamQueryPersister().persist(dto)
            .subscribeOn(Schedulers.io())
            .doOnError {
                it.printStackTrace()
            }
            .subscribe()
    }

    override fun shouldProcessEvent(dto: EkoStreamListDto): Boolean {
        return true
    }

}